/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.git.core.github.IGithubUser;
import com.aptana.git.internal.core.github.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.osgi.framework.Version;

public class GithubAPI {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CONTENT_TYPES = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String BASE_URL = "https://api.github.com/";
    private static final String ATTR_MESSAGE = "message";
    private final String username;
    private final String password;

    GithubAPI(String username, String password) {
        this.username = username;
        this.password = password;
    }

    GithubAPI(IGithubUser user) {
        this(user.getUsername(), user.getPassword());
    }

    protected Object get(String url) throws CoreException {
        this.checkCredentials();
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(BASE_URL + url);
            int code = connection.getResponseCode();
            JSONParser parser = new JSONParser();
            if (code == 200) {
                String response = IOUtil.read((InputStream)connection.getInputStream());
                Object object = parser.parse(response);
                return object;
            }
            try {
                String response = IOUtil.read((InputStream)connection.getErrorStream());
                JSONObject result = (JSONObject)parser.parse(response);
                String msg = (String)result.get((Object)ATTR_MESSAGE);
                throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", code, msg, null));
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", -1, null, (Throwable)e));
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkCredentials() throws CoreException {
        if (this.username == null || this.password == null) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", -1, Messages.GithubManager_ERR_Github_NotLoggedIn, null));
        }
    }

    protected Object post(String url, String data) throws CoreException {
        return this.putOrPost(url, data, "POST", 201, 202);
    }

    private HttpURLConnection createConnection(String urlString) throws MalformedURLException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT, this.getUserAgentString());
        connection.setRequestProperty(ACCEPT_HEADER, ACCEPT_CONTENT_TYPES);
        connection.setRequestProperty(CONTENT_TYPE, ACCEPT_CONTENT_TYPES);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        String usernamePassword = String.valueOf(this.username) + ":" + this.password;
        connection.setRequestProperty(AUTHORIZATION_HEADER, "Basic " + new String(Base64.encode((byte[])usernamePassword.getBytes())));
        return connection;
    }

    private String getUserAgentString() {
        String versionStr = EclipseUtil.getStudioVersion();
        Version version = new Version(versionStr);
        return MessageFormat.format("{0} {1}.{2}.{3}", EclipseUtil.getProductName(), version.getMajor(), version.getMinor(), version.getMicro());
    }

    protected Object put(String url, String data) throws CoreException {
        return this.putOrPost(url, data, "PUT", 200);
    }

    private Object putOrPost(String url, String data, String method, int ... successCodes) throws CoreException {
        this.checkCredentials();
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(BASE_URL + url);
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            IOUtil.write((OutputStream)out, (String)data);
            out.close();
            int code = connection.getResponseCode();
            JSONParser parser = new JSONParser();
            if (ArrayUtil.contains((int[])successCodes, (int)code)) {
                String response = IOUtil.read((InputStream)connection.getInputStream());
                Object object = parser.parse(response);
                return object;
            }
            try {
                String response = IOUtil.read((InputStream)connection.getErrorStream());
                if (response == null) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", code, MessageFormat.format("Empty error response body from server. Response code: {0}, expected success codes: {1}", code, Arrays.toString(successCodes)), null));
                }
                JSONObject result = (JSONObject)parser.parse(response);
                String msg = (String)result.get((Object)ATTR_MESSAGE);
                throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", code, msg, null));
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", -1, null, (Throwable)e));
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

